program StripLisaText;

{ V1.0 convert an Apple Lisa TEXT file to a plain text file
  Hans Otten, 2024
  CLI utility

  Usage:
    - add StripLisaText.exe to your path
    - in the folder with textfiles type StripLisaText
}

{

  MIT License

  Copyright (c) 2019-2024 Hans Otten

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in all
  copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
  }

{
To enable FileUtil in your project, please add LazUtils into required packages.
Follow these steps:
- Go to Lazarus IDE Menu > Project > Project Inspector
- In the Project Inspector dialog window, click Add > New Requirement
- In the New Requirement dialog window, find LazUtils package then click OK.
}

{$mode objfpc}{$H+}

uses
  {$IFDEF UNIX}
  cthreads,
  {$ENDIF}
  Classes, SysUtils, FileUtil ;

var
  infile    : file of byte  ;
  outfile   : text ;
  dbyte     : byte ;
  cnt       : integer ;
  ListOfFiles: TStringList;

procedure StripLisaFile(filename: string) ;

var
  outfilename : string ;
  cnt : integer ;
begin
  assign(infile, filename) ;
  if FileExists(filename)
    then
      reset(infile)
    else
      begin
        writeln('No such file ', filename) ;
        exit
      end;
  outfilename := filename + '.txt' ;
  assign (outfile, outfilename) ;
  rewrite(outfile) ;
  { skip header $400 bytes }
  for cnt := 0 to $3FF do
    read(infile, dbyte) ;
  while not eof(infile) do
    begin
      read(infile, dbyte) ;
      { CR to CRLF }
      if dbyte = $0D
        then
          writeln(outfile)
      { convert DLE sequence to spaces }
      else if dbyte = $10
        then
           begin
             { add padding to output }
             read(infile, dbyte) ;
             for cnt := 1 to (dbyte - $20) do
               write(outfile, ' ' )
           end
      { skip filler nulls }
      else if dbyte <> 0
        then
          write(outfile,chr(dbyte)) ;
    end ;
  writeln(outfile) ;
  close(infile) ;
  close(outfile) ;
end ;


begin
  writeln('V1.0 Convert a  Lisa Pascal TEXT source to plain txt file, (C) Hans Otten 2024') ;
  ListOfFiles := TStringList.Create;
  FileUtil.FindAllFiles(ListOfFiles, '','*.TEXT', false);
  for cnt := 0 to ListofFiles.count -1 do
    StripLisaFile(ListOfFiles[cnt]) ;
  writeln('Convert finished, number of files converted ', ListofFiles.count) ;
  ListOfFiles.Free;
end.


